 <?php
// +----------------------------------------------------------------------+
// | BoletoPhp - Verso Beta                                              |
// +----------------------------------------------------------------------+
// | Este arquivo est disponvel sob a Licena GPL disponvel pela Web   |
// | em http://pt.wikipedia.org/wiki/GNU_General_Public_License           |
// | Voc deve ter recebido uma cpia da GNU Public License junto com     |
// | esse pacote; se no, escreva para:                                   |
// |                                                                      |
// | Free Software Foundation, Inc.                                       |
// | 59 Temple Place - Suite 330                                          |
// | Boston, MA 02111-1307, USA.                                          |
// +----------------------------------------------------------------------+

// +----------------------------------------------------------------------+
// | Originado do Projeto BBBoletoFree que tiveram colaboraes de Daniel |
// | William Schultz e Leandro Maniezo que por sua vez foi derivado do	  |
// | PHPBoleto de Joo Prado Maia e Pablo Martins F. Costa			       	  |
// | 																	                                    |
// | Se vc quer colaborar, nos ajude a desenvolver p/ os demais bancos :-)|
// | Acesse o site do Projeto BoletoPhp: www.boletophp.com.br             |
// +----------------------------------------------------------------------+

// +----------------------------------------------------------------------+
// | Equipe Coordenao Projeto BoletoPhp: <boletophp@boletophp.com.br>   |
// | Desenvolvimento Boleto Bradesco: Ramon Soares						            |
// +----------------------------------------------------------------------+

	// ------------------------- DADOS DINMICOS DO SEU CLIENTE PARA A GERAO DO BOLETO (FIXO OU VIA GET) -------------------- //
	// Os valores abaixo podem ser colocados manualmente ou ajustados p/ formulrio c/ POST, GET ou de BD (MySql,Postgre,etc)	//
	
	// print_r($result);
	
	// DADOS DO BOLETO PARA O SEU CLIENTE
	$dias_de_prazo_para_pagamento		= 0;
	$taxa_boleto						= 0;
	$valor_cobrado						= str_replace(",", ".", $result->ValorBoleto);
	$valor_boleto						= number_format($valor_cobrado + $taxa_boleto, 2, ',', '');

	$dadosboleto["nosso_numero"]		= substr($result->NossoNumero, 0, 11);							// Nosso numero sem o DV - REGRA: Mximo de 11 caracteres!
	$dadosboleto["numero_documento"]	= "";															// Num do pedido ou do documento = Nosso numero
	$dadosboleto["data_vencimento"]		= date_format(date_create($result->DataVencimento), 'd/m/Y');	// Data de Vencimento do Boleto - REGRA: Formato DD/MM/AAAA
	$dadosboleto["data_documento"]		= date_format(date_create($result->DataEmissao), 	'd/m/Y'); 	// Data de emisso do Boleto
	$dadosboleto["data_processamento"]	= date_format(date_create($result->DataEmissao), 	'd/m/Y'); 	// Data de processamento do boleto (opcional)
	$dadosboleto["valor_boleto"]		= $valor_boleto;												// Valor do Boleto - REGRA: Com vrgula e sempre com duas casas depois da virgula

	// DADOS DO SEU CLIENTE
	$dadosboleto["sacado"]		= $result->Sacado_Nome;
	$dadosboleto["endereco1"]	= $result->Sacado_Endereco;
	$dadosboleto["endereco2"]	= $result->Sacado_Cidade ." - "; 
	$dadosboleto["endereco2"]  .= $result->Sacado_Uf ." - ";	
	$dadosboleto["endereco2"]  .= $result->Sacado_Cep ;

	// INFORMACOES PARA O CLIENTE
	$dadosboleto["demonstrativo1"] = $demonstrativo[0]; 
	$dadosboleto["demonstrativo2"] = $demonstrativo[1];
	$dadosboleto["demonstrativo3"] = $demonstrativo[2]; 
	$dadosboleto["demonstrativo4"] = $demonstrativo[3]; 
	$dadosboleto["demonstrativo5"] = $demonstrativo[4]; 

	// INSTRUES PARA O CAIXA
    $dadosboleto["instrucoes1"] = $instrucao[0]; 
	$dadosboleto["instrucoes2"] = $instrucao[1];  
	$dadosboleto["instrucoes3"] = $instrucao[2];  
	$dadosboleto["instrucoes4"] = $instrucao[3];  
	$dadosboleto["instrucoes5"] = $instrucao[4];	
	$dadosboleto["instrucoes6"] = $instrucao[5];

	// DADOS OPCIONAIS DE ACORDO COM O BANCO OU CLIENTE
	$dadosboleto["quantidade"]		= "001";
	$dadosboleto["valor_unitario"]	= $valor_boleto;
	$dadosboleto["aceite"]			= "";		
	$dadosboleto["especie"]			= "R$";
	$dadosboleto["especie_doc"]		= "DS";

	// ---------------------- DADOS FIXOS DE CONFIGURAO DO SEU BOLETO --------------- //

	// DADOS DA SUA CONTA - Bradesco
	$dadosboleto["agencia"]		= ""+ $result->Agencia +"";			// Num da agencia, sem digito
	$dadosboleto["agencia_dv"]	= ""+ $result->AgenciaDv +"";		// Digito do Num da agencia
	$dadosboleto["conta"]		= ""+ $result->Conta +""; 			// Num da conta, sem digito
	$dadosboleto["conta_dv"]	= ""+ $result->ContaDv +""; 		// Digito do Num da conta

	// DADOS PERSONALIZADOS - Bradesco
	$dadosboleto["conta_cedente"]		= $result->Conta;			// ContaCedente do Cliente, sem digito (Somente Nmeros)
	$dadosboleto["conta_cedente_dv"]	= $result->ContaDv;			// Digito da ContaCedente do Cliente
	$dadosboleto["carteira"]			= $result->Carteira;		// Cdigo da Carteira: pode ser 06 ou 03

	// SEUS DADOS
	$dadosboleto["identificacao"]	= $result->Cedente_Nome;
	$dadosboleto["cpf_cnpj"]		= $result->Cedente_CpfCnpj;
	$dadosboleto["endereco"]		= $result->Cedente_Endereco;
	$dadosboleto["cidade_uf"]		= $result->Cedente_Cidade ." / ". $result->Cedente_UF ;
	$dadosboleto["cedente"]			= $result->Cedente_Nome;

	// NO ALTERAR!
	require_once("include/funcoes_bradesco.php"); 
	require_once("include/layout_bradesco.php");
	
?>
