<?php

// +----------------------------------------------------------------------+
// | BoletoPhp - Verso Beta                                              |
// +----------------------------------------------------------------------+
// | Este arquivo est disponvel sob a Licena GPL disponvel pela Web   |
// | em http://pt.wikipedia.org/wiki/GNU_General_Public_License           |
// | Voc deve ter recebido uma cpia da GNU Public License junto com     |
// | esse pacote; se no, escreva para:                                   |
// |                                                                      |
// | Free Software Foundation, Inc.                                       |
// | 59 Temple Place - Suite 330                                          |
// | Boston, MA 02111-1307, USA.                                          |
// +----------------------------------------------------------------------+

// +----------------------------------------------------------------------+
// | Originado do Projeto BBBoletoFree que tiveram colaboraes de Daniel |
// | William Schultz e Leandro Maniezo que por sua vez foi derivado do	  |
// | PHPBoleto de Joo Prado Maia e Pablo Martins F. Costa		      		  |
// | 																	                                    |
// | Se vc quer colaborar, nos ajude a desenvolver p/ os demais bancos :-)|
// | Acesse o site do Projeto BoletoPhp: www.boletophp.com.br             |
// +----------------------------------------------------------------------+

// +----------------------------------------------------------------------+
// | Equipe Coordenao Projeto BoletoPhp: <boletophp@boletophp.com.br>   |
// | Desenv Boleto SICREDI: Rafael Azenha Aquini <rafael@tchesoft.com>    |
// |                        Marco Antonio Righi <marcorighi@tchesoft.com> |
// | Homologao e ajuste de algumas rotinas.				               			  |
// |                        Marcelo Belinato  <mbelinato@gmail.com> 		  |
// +----------------------------------------------------------------------+


		// ------------------------- DADOS DINMICOS DO SEU CLIENTE PARA A GERAO DO BOLETO (FIXO OU VIA GET) -------------------- //
		// Os valores abaixo podem ser colocados manualmente ou ajustados p/ formulrio c/ POST, GET ou de BD (MySql,Postgre,etc)	//

		// DADOS DO BOLETO PARA O SEU CLIENTE
		$dias_de_prazo_para_pagamento	= 0;
		$taxa_boleto					= 0;
		$valor_cobrado					= str_replace(",", ".", $result->ValorBoleto);
		$valor_boleto					= number_format($valor_cobrado + $taxa_boleto, 2, ',', '');
		$tipo_cobranca 					= 1;
		$tipo_carteira					= 1;
		
		if ($result->Carteira == 'A') {
			$tipo_cobranca = 1;
		} else {
			$tipo_cobranca = 3;
		}
		
		$dadosboleto["inicio_nosso_numero"] = substr($result->NossoNumero, 0, 2);							// Ano da gerao do ttulo ex: 07 para 2007 
		$dadosboleto["nosso_numero"]		= substr($result->NossoNumero, 3, 5);  							// Nosso numero (mx. 5 digitos) - Numero sequencial de controle.
		$dadosboleto["numero_documento"]	= "";															// Num do pedido ou do documento
		$dadosboleto["data_vencimento"]		= date_format(date_create($result->DataVencimento), 'd/m/Y');	// Data de Vencimento do Boleto - REGRA: Formato DD/MM/AAAA
		$dadosboleto["data_documento"]		= date_format(date_create($result->DataEmissao), 	'd/m/Y');	// Data de emisso do Boleto
		$dadosboleto["data_processamento"]	= date_format(date_create($result->DataEmissao), 	'd/m/Y');	// Data de processamento do boleto (opcional)
		$dadosboleto["valor_boleto"]		= $valor_boleto; 												// Valor do Boleto - REGRA: Com vrgula e sempre com duas casas depois da virgula

		// DADOS DO SEU CLIENTE		
		$dadosboleto["sacado"]		= $result->Sacado_Nome;
		$dadosboleto["endereco1"]	= $result->Sacado_Endereco;
		$dadosboleto["endereco2"]	= $result->Sacado_Cidade ." - "; 
		$dadosboleto["endereco2"]  .= $result->Sacado_Uf ." - ";	
		$dadosboleto["endereco2"]  .= $result->Sacado_Cep ;

		// INFORMACOES PARA O CLIENTE
		$dadosboleto["demonstrativo1"] = $demonstrativo[0]; 
		$dadosboleto["demonstrativo2"] = $demonstrativo[1];
		$dadosboleto["demonstrativo3"] = $demonstrativo[2]; 
		$dadosboleto["demonstrativo4"] = $demonstrativo[3]; 
		$dadosboleto["demonstrativo5"] = $demonstrativo[4]; 

		// INSTRUES PARA O CAIXA
		$dadosboleto["instrucoes1"] = $instrucao[0]; 
		$dadosboleto["instrucoes2"] = $instrucao[1];  
		$dadosboleto["instrucoes3"] = $instrucao[2];  
		$dadosboleto["instrucoes4"] = $instrucao[3];  
		$dadosboleto["instrucoes5"] = $instrucao[4];	
		$dadosboleto["instrucoes6"] = $instrucao[5];


		// DADOS OPCIONAIS DE ACORDO COM O BANCO OU CLIENTE
		$dadosboleto["quantidade"]		= "";
		$dadosboleto["valor_unitario"]	= "";
		$dadosboleto["aceite"]			= $result->Aceite;	    	// N - remeter cobrana sem aceite do sacado  (cobranas no-registradas)// S - remeter cobrana apos aceite do sacado (cobranas registradas)
		$dadosboleto["especie"]			= $result->Especie;
		$dadosboleto["especie_doc"]		= $result->EspecieDocSigla;		// OS - Outros segundo manual para cedentes de cobrana SICREDI

		// ---------------------- DADOS FIXOS DE CONFIGURAO DO SEU BOLETO --------------- //

		// DADOS DA SUA CONTA - SICREDI
		$dadosboleto["agencia"]		= ""+ $result->Agencia +"";			// Num da agencia, sem digito
		$dadosboleto["conta"]		= ""+ $result->Conta +""; 			// Num da conta, sem digito
		$dadosboleto["conta_dv"]	= ""+ $result->ContaDv +""; 		// Digito do Num da conta

		// DADOS PERSONALIZADOS - SICREDI
		$dadosboleto["posto"]		= $result->Posto;					// Cdigo do posto da cooperativa de crdito
		$dadosboleto["byte_idt"]	= "2";								// Byte de identificao do cedente do bloqueto utilizado para compor o nosso nmero.// 1 - Idtf emitente: Cooperativa | 2 a 9 - Idtf emitente: Cedente
		$dadosboleto["carteira"]	= $result->Carteira;				// Cdigo da Carteira: A (Simples) 

		// SEUS DADOS		
		$dadosboleto["identificacao"]	= $result->Cedente_Nome;
		$dadosboleto["cpf_cnpj"]		= $result->Cedente_CpfCnpj;
		$dadosboleto["endereco"]		= $result->Cedente_Endereco;
		$dadosboleto["cidade_uf"]		= $result->Cedente_Cidade ." / ". $result->Cedente_UF ;
		$dadosboleto["cedente"]			= $result->Cedente_Nome;

		// NO ALTERAR!
		include("include/funcoes_sicredi.php"); 
		include("include/layout_sicredi.php");

?>
