<?php

	require_once('stringutil.php'); 
	
	class TBoletoCarteiraBase 
	{	
		var $util;
		
		var $DataVencimento       = null ;
		var $ValorBoleto          = 0 ;
		var $SequenciaNossoNumero = 0 ;
		var $Agencia              = "" ;
		var $AgenciaDV            = "" ;
		var $Conta                = "" ;
		var $ContaDV              = "" ;
		var $Carteira             = "" ;
		var $Convenio             = "" ;
		var $Posto                = "" ;
		var $Codigo               = "" ;
	
		function __construct() 
		{
			$this->util = new StringUtil();
		}
		
		function Modulo11($N, $base)
		{
			$m = 2;
			$Somatorio = 0;
			for ($i = strlen($N)-1; $i >= 0; $i--)
			{
				$Somatorio = $Somatorio + ($N[$i] * $m);
				$m++;
				if ($m == ($base + 1)) 
					$m = 2;
			}
			$m = 11 - ($Somatorio % 11);
			if (($m == 0) || ($m == 10) || ($m == 11)) 
				$m = 1;
			return $m;
		}

		function Modulo10($N)
		{
			$Somatorio = 0;
			if (strlen($N) % 2 == 0)
				$m = 1;
			else 
				$m = 2;
		  
			for ($i = 0; $i <= strlen($N)-1; $i++)
			{
				$k = $N[$i] * $m;
				if ($k > 9) {  
					$k = 1 + ($k - 10);
				}
				$Somatorio = $Somatorio + $k;
				if ($m == 1) { 
					$m = 2;
				} else { 
					$m = 1;
				}
			}
			
			$m = $Somatorio % 10;
			if (($m == 0) || ($m == 10)) 
				$m = 0;
			else
				$m = 10 - $m;
			
			return $m;
		}

		function RetornaFatorVencimento($data)
		{			
			if (strtotime($data)){
				$t = date("d/m/Y", strtotime($data));
			}
					
			$list = explode("/", $t);
			$ano = $list[2];
			$mes = $list[1];
			$dia = $list[0];
			
			return(abs(($this->_dateToDays("1997","10","07")) - ($this->_dateToDays($ano, $mes, $dia))));
		}
		
		function _dateToDays($year,$month,$day) 
		{
			$century = substr($year, 0, 2);
			$year = substr($year, 2, 2);
			if ($month > 2) {
				$month -= 3;
			} else {
				$month += 9;
				if ($year) {
					$year--;
				} else {
					$year = 99;
					$century --;
				}
			}
			return ( floor((  146097 * $century)    /  4 ) +
					floor(( 1461 * $year)        /  4 ) +
					floor(( 153 * $month +  2) /  5 ) +
						$day +  1721119);
		}

		function DigitoCodigoBarras($N)
		{
			if (strlen($N) != 43) 
				throw new Exception('ERRO DigitoCodigoBarras: Tamanho CODIGO DE BARRAS 43 e esta ' .strlen($N));			
			else
				return $this->Modulo11($N,9);
		}

		function CheckCodigoBarras($CodigoBarras)
		{
			$this->ValidaTamanho($CodigoBarras, 44, 'Tamanho CODIGO DE BARRAS 44 e esta ' .strlen($CodigoBarras));
			return true ;
		}

		function CheckLinhaDigitavel($LinhaDigitavel)
		{
			$this->ValidaTamanho($LinhaDigitavel, 47, 'Tamanho LINHA DIGITAVEL 44 e esta ' .strlen($LinhaDigitavel));
			return true ;
		}

		function FormatarValor($ValorBoleto)
		{			
			$valorStr = $this->util->FormatCurr('#,##0.00', $ValorBoleto);
			$valorStr = str_replace(',', '', $valorStr);
			$valorStr = str_replace('.', '', $valorStr);
			$valorStr = $this->util->ZeroEsquerda($valorStr, 10);
			return $valorStr ;
		}

		function ValidaTamanho($Str, $Tamanho, $Mensagem)
		{
			if (strlen($Str) != $Tamanho) 
				throw new Exception($Mensagem .' Obrigatório: '. $Tamanho .' Tamanho: ' .strlen($Str));
		}
	}
	
?>