<?php

	require_once('stringutil.php'); 
	require_once('cob_carteira_base.php');
	
	class TBoletoCarteiraBradesco_06_09_16_19 
	{
		var $util;
		var $base;
		
		var $CodigoBanco = "";
		var $NumeroMoeda = "";
		var $Ios = "";
		var $Fixo = "";
		var $FatorVencimento = "";
		var $TamanhoNossoNumeroComDV = 0 ;
		var $ValorStr = "";
		var $NossoNumeroDVStr = "";
		var $NossoNumeroSemDVStr = "";
		var $CampoLivre = "";
		var $BarraDvStr = "";
		var $PermiteSemCPF = 0 ;
		var $SegmentoMensagem = 0 ;
		
		var $ValorBoleto = 0.0 ;
		var $DataVencimento = null;
		var $Agencia;
		var $Carteira;
		var $Conta;
		var $SequenciaNossoNumero;

		function __construct() 
		{
			$this->util = new StringUtil();
			$this->base = new TBoletoCarteiraBase();
		}
		
		function Prepare()
		{
			$this->PermiteSemCPF           	= 1;
			$this->SegmentoMensagem        	= 80;  
			$this->CodigoBanco             	= '237';
			$this->NumeroMoeda             	= '9';
			$this->TamanhoNossoNumeroComDV 	= 12;    	// Quantidade de dígitos Nosso Número(com DV)
			$this->Fixo     	            = '9';   	// Numero fixo para a posição 05-05
			$this->Ios	  		            = '0';   	// IOS - somente para Seguradoras (Se 7% informar 7, limitado 9%) // Demais clientes usar 0 (zero)
			$this->FatorVencimento         	= $this->base->RetornaFatorVencimento($this->DataVencimento);
			$this->ValorStr                	= $this->base->FormatarValor($this->ValorBoleto);
			$this->NossoNumeroDVStr        	= $this->FormatarNossoNumeroDV();
			$this->NossoNumeroSemDVStr     	= substr($this->NossoNumeroDVStr, 0, strlen($this->NossoNumeroDVStr)-1);
			
			$this->CampoLivre = "";
			$this->CampoLivre .= $this->util->ZeroEsquerda($this->Agencia,4);
			$this->CampoLivre .= $this->util->ZeroEsquerda($this->Carteira,2);
			$this->CampoLivre .= $this->NossoNumeroSemDVStr;
			$this->CampoLivre .= $this->util->ZeroEsquerda($this->Conta,7) ;
			$this->CampoLivre .= '0';
		}

		function Modulo11NN($N, $base)
		{			
			$m = 2;
			$Somatorio = 0;
			for ($i = strlen($N)-1; $i >=0; $i--)
			{
				$Somatorio = $Somatorio + ($N[$i] * $m);
				$m++;
				if ($m == ($base + 1))
					$m = 2;
			}

			$m = ($Somatorio % 11);
			if ($m == 1)
				return 'P';
			else if ($m == 0) 
				return'0';
			else
				return (11-$m);
		}

		function FormatarNossoNumeroDV()
		{
			$NN = $this->util->ZeroEsquerda($this->SequenciaNossoNumero, $this->TamanhoNossoNumeroComDV-1);
			$DV = $this->Modulo11NN($this->Carteira .$NN, 7);
			return $NN .$DV;
		}

		function FormatarNossoNumeroImpresso()
		{
			$NN = $this->util->ZeroEsquerda($this->SequenciaNossoNumero, $this->TamanhoNossoNumeroComDV-1);
			$DV = $this->Modulo11NN($this->Carteira .$NN, 7);
			return $NN .'-'. $DV;
		}

		function FormatarCodigoBarras()
		{
			$BarraSemDvTmp = $this->CodigoBanco .$this->NumeroMoeda .$this->FatorVencimento .$this->ValorStr .$this->CampoLivre;
			
			$this->BarraDvStr = $this->base->DigitoCodigoBarras($BarraSemDvTmp);

			$Result = substr($BarraSemDvTmp, 0, 4) .$this->BarraDvStr .substr($BarraSemDvTmp, 4, 39);
			$this->base->CheckCodigoBarras($Result);
			return $Result;
		}

		function FormatarLinhaDigitavel($CodigoBarras)
		{   
			$Campo1 = $this->CodigoBanco .$this->NumeroMoeda .substr($this->CampoLivre,0,5);
			$Campo1 = $Campo1 .$this->base->Modulo10($Campo1);
			$Campo2 = substr($this->CampoLivre, 5, 10)	 .$this->base->Modulo10(substr($this->CampoLivre, 5, 10));
			$Campo3 = substr($this->CampoLivre, 15, 10) .$this->base->Modulo10(substr($this->CampoLivre, 15, 10));
			$Campo4 = $this->BarraDvStr;
			$Campo5 = $this->FatorVencimento .$this->ValorStr;
			
			$Result = $Campo1 .$Campo2 .$Campo3 .$Campo4 .$Campo5;			
			$this->base->CheckLinhaDigitavel($Result);
			return $Result;
		}
    }
	
?>