<?php

	require_once('stringutil.php'); 
	require_once('cob_carteira_base.php');
	
	class TBoletoCarteiraSantander
	{
		var $util;
		var $base;
		
		var $CodigoBanco = "";
		var $NumeroMoeda = "";
		var $Ios = "";
		var $Fixo = "";
		var $FatorVencimento = "";
		var $TamanhoNossoNumeroComDV = 8 ;
		var $ValorStr = "";
		var $NossoNumeroDVStr = "";
		var $NossoNumeroSemDVStr = "";
		var $CampoLivre = "";
		var $BarraDvStr = "";
		var $PermiteSemCPF = 0 ;
		var $SegmentoMensagem = 0 ;
		
		var $ValorBoleto = 0 ;
		var $DataVencimento = null;
		var $Agencia;
		var $Carteira;
		var $Conta;
		var $SequenciaNossoNumero;

		function __construct() 
		{
			$this->util = new StringUtil();
			$this->base = new TBoletoCarteiraBase();
		}
		
		function Prepare()
		{
			$this->PermiteSemCPF           	= 0;
			$this->SegmentoMensagem        	= 50;  
			$this->CodigoBanco             	= '033';
			$this->NumeroMoeda             	= '9';

			$this->Fixo     	            = '9';   	// Numero fixo para a posição 05-05
			$this->Ios	  		            = '0';   	// IOS - somente para Seguradoras (Se 7% informar 7, limitado 9%) // Demais clientes usar 0 (zero)
			$this->FatorVencimento         	= $this->base->RetornaFatorVencimento($this->DataVencimento);
			$this->ValorStr                	= $this->base->FormatarValor($this->ValorBoleto);
			$this->NossoNumeroDVStr        	= $this->FormatarNossoNumeroDV();
			$this->NossoNumeroSemDVStr     	= substr($this->NossoNumeroDVStr, 0, strlen($this->NossoNumeroDVStr)-1);
			
			$this->CampoLivre = "9";
			$this->CampoLivre .= $this->util->ZeroEsquerda($this->Convenio,7);
			$this->CampoLivre .= $this->util->ZeroEsquerda($this->NossoNumeroDVStr, 13);
			$this->CampoLivre .= '0';

			if (($this->Carteira == '1') || ($this->Carteira == '5')) {
				$this->CampoLivre .= '101';
			} else if (Carteira == '4') {
				$this->CampoLivre .= '102';
			}	
		}

		function FormatarNossoNumeroDV()
		{
			$NN = $this->util->ZeroEsquerda($this->SequenciaNossoNumero, 7);
			$DV = $this->modulo_11($NN, 9, 0);
			return $NN .$DV;
		}

		function FormatarNossoNumeroImpresso()
		{
			$NN = $this->util->ZeroEsquerda($this->SequenciaNossoNumero, 11);
			$DV = $this->modulo_11($NN, 9, 0);
			return $NN .'-'. $DV;
		}

		function FormatarCodigoBarras()
		{
			$BarraSemDvTmp = $this->CodigoBanco .$this->NumeroMoeda .$this->FatorVencimento .$this->ValorStr .$this->CampoLivre;
			
			$this->BarraDvStr = $this->base->DigitoCodigoBarras($BarraSemDvTmp);

			$Result = substr($BarraSemDvTmp, 0, 4) .$this->BarraDvStr .substr($BarraSemDvTmp, 4, 39);
			$this->base->CheckCodigoBarras($Result);
			return $Result;
		}

		function FormatarLinhaDigitavel($CodigoBarras)
		{   
			$Campo1 = $this->CodigoBanco .$this->NumeroMoeda .substr($this->CampoLivre,0,5);
			$Campo1 = $Campo1 .$this->base->Modulo10($Campo1);
			$Campo2 = substr($this->CampoLivre, 5, 10)	 .$this->base->Modulo10(substr($this->CampoLivre, 5, 10));
			$Campo3 = substr($this->CampoLivre, 15, 10) .$this->base->Modulo10(substr($this->CampoLivre, 15, 10));
			$Campo4 = $this->BarraDvStr;
			$Campo5 = $this->FatorVencimento .$this->ValorStr;
			
			$Result = $Campo1 .$Campo2 .$Campo3 .$Campo4 .$Campo5;			
			$this->base->CheckLinhaDigitavel($Result);
			return $Result;
		}
		
		function modulo_11($num, $base=9, $r=0)  
		{
			$soma = 0;
			$fator = 2;

			/* Separacao dos numeros */
			for ($i = strlen($num); $i > 0; $i--) {
				// pega cada numero isoladamente
				$numeros[$i] = substr($num,$i-1,1);
				// Efetua multiplicacao do numero pelo falor
				$parcial[$i] = $numeros[$i] * $fator;
				// Soma dos digitos
				$soma += $parcial[$i];
				if ($fator == $base) {
					// restaura fator de multiplicacao para 2 
					$fator = 1;
				}
				$fator++;
			}

			/* Calculo do modulo 11 */
			if ($r == 0) {
				$soma *= 10;
				$digito = $soma % 11;
				if ($digito == 10) {
					$digito = 0;
				}
				return $digito;
			} elseif ($r == 1){
				$resto = $soma % 11;
				return $resto;
			}
		}
    }
	
?>