<?php

	class
  TBoletoCarteiraSicoob 
  private
    fCodigoBanco : String;
    fNumeroMoeda : String ;
    fIos : String ;
    fFixo : String ;
    fFatorVencimento : String;
    fTamanhoNossoNumeroComDV : Smallint;
    fValorStr : String;
    fNossoNumeroDVStr : String;
    fNossoNumeroSemDVStr : String;
    fCampoLivre : String;
    fBarraDvStr : String;
    fPermiteSemCPF: Integer;
    fSegmentoMensagem : Integer;
    function Modulo11NN(N : string; Base : Smallint) : string;
  public
    procedure Prepare(); override;
    function FormatarCodigoBarras() : String; override ;
    function FormatarLinhaDigitavel(CodigoBarras : String) : String ; override ;
    function FormatarNossoNumeroDV: String;override ;
    function FormatarNossoNumeroImpresso: String; override ;
  end;


implementation

uses U_StringUtil;

{ TBoletoCarteiraSicoob }

Procedure TBoletoCarteiraSicoob.Prepare;
begin
  fPermiteSemCPF           := 0;
  fSegmentoMensagem        := 0;
  fCodigoBanco             := '756';
  fNumeroMoeda             := '9';
  fTamanhoNossoNumeroComDV := 12;    // Quantidade de dígitos Nosso Número(com DV)
  fFixo     	              := '9';   // Numero fixo para a posição 05-05
  fIos	  		              := '0';   // IOS - somente para Seguradoras (Se 7% informar 7, limitado 9%) // Demais clientes usar 0 (zero)
  fFatorVencimento         := RetornaFatorVencimento(DataVencimento);
  fValorStr                := FormatarValor(ValorBoleto);
  fNossoNumeroDVStr        := FormatarNossoNumeroDV;
  fNossoNumeroSemDvStr     := Copy(fNossoNumeroDVStr,1,length(fNossoNumeroDVStr)-1);
  fcampoLivre              := Copy(Carteira,2,1) +
                              ZeroEsquerda(Agencia,4) +
                              ZeroEsquerda(Carteira,2) +
                              ZeroEsquerda(Convenio,7) +
                              Copy(fNossoNumeroDVStr,5,8) +
                              '001';
end;

function TBoletoCarteiraSicoob.Modulo11NN(N : string; Base : Smallint) : string;
const
    cConstante:  array[1..4] of integer = (7,9,1,3);
var
  Somatorio,i,m,f : Integer;
begin
// N := '0001'+'0000000019'+'0000021';
  N := ZeroEsquerda(Agencia,4)+ZeroEsquerda(Convenio,10)+ZeroEsquerda(N,7);
  i := 4;
  m := cConstante[i];
  Somatorio := 0;
  for f := Length(N) downto 1 do
    begin
      Somatorio := Somatorio + (StrToInt(N[f]) * m);
      inc(i);
      if i>4 then
         i := 1;
        m := cConstante[i];
    end;
  m      := (Somatorio mod 11);
  if (m = 0) or (m = 1) then
     Result  := '0'
  else
     Result  := IntToStr(11-m);
end;

function TBoletoCarteiraSicoob.FormatarNossoNumeroDV: String;
var
  NN : String;
begin
  NN := ZeroEsquerda(FloatToStr(SequenciaNossoNumero),fTamanhoNossoNumeroComDV-1);
  NN := NN + Modulo11NN(NN,8);
  Result := ZeroEsquerda(NN,12) ;
end;

function TBoletoCarteiraSicoob.FormatarNossoNumeroImpresso: String;
var
  NN, DV : String;
begin
  NN := ZeroEsquerda(FloatToStr(SequenciaNossoNumero),fTamanhoNossoNumeroComDV-1);
  DV := Modulo11NN(NN,8);
  Result := NN +'-'+ DV;
end;

function TBoletoCarteiraSicoob.FormatarCodigoBarras: String;
var
  BarraSemDvTmp : String ;
begin
  Result := '';

  BarraSemDvTmp :=  fCodigoBanco +
                    fNumeroMoeda +
                    fFatorVencimento +
                    fValorStr +
                    fCampoLivre;


  fBarraDvStr := DigitoCodigoBarras(BarraSemDvTmp);

  Result := Copy(BarraSemDvTmp,1,4) + fBarraDvStr + Copy(BarraSemDvTmp, 5, 39);
  CheckCodigoBarras(Result);
end;

function TBoletoCarteiraSicoob.FormatarLinhaDigitavel(CodigoBarras : String): String;
var
   Campo1,
   Campo2,
   Campo3,
   Campo4,
   Campo5 : String;
begin
   Campo1 :=  fCodigoBanco +
              fNumeroMoeda +
              Copy(fCampoLivre,1,5);
   Campo1 := Campo1 + Modulo10(Campo1);
   Campo2 := Copy(fCampoLivre,6,10)+Modulo10(Copy(fCampoLivre,6,10));
   Campo3 := Copy(fCampoLivre,16,10)+Modulo10(Copy(fCampoLivre,16,10));
   Campo4 := fBarraDvStr;
   Campo5 := fFatorVencimento + fValorStr;
   Result := Campo1+Campo2+Campo3+Campo4+Campo5;
   CheckLinhaDigitavel(Result);
end;

end.