<?php

	require_once('stringutil.php'); 
	require_once('cob_carteira_base.php');
	
	class TBoletoCarteiraSicredi
	{
		var $util;
		var $base;
		
		var $CodigoBanco = "";
		var $NumeroMoeda = "";
		var $Ios = "";
		var $Fixo = "";
		var $FatorVencimento = "";
		var $TamanhoNossoNumeroComDV = 0 ;
		var $ValorStr = "";
		var $NossoNumeroDVStr = "";
		var $NossoNumeroSemDVStr = "";
		var $CampoLivre = "";
		var $BarraDvStr = "";
		var $PermiteSemCPF = 0 ;
		var $SegmentoMensagem = 0 ;
		
		var $ValorBoleto = 0 ;
		var $DataVencimento = null;
		var $Agencia;
		var $Carteira;
		var $Conta;
		var $SequenciaNossoNumero;
		var $Convenio;

		function __construct() 
		{
			$this->util = new StringUtil();
			$this->base = new TBoletoCarteiraBase();
		}
		
		function Prepare()
		{
			$this->PermiteSemCPF           	= 0;
			$this->SegmentoMensagem        	= 50;  
			$this->CodigoBanco             	= '748';
			$this->NumeroMoeda             	= '9';
			$this->TamanhoNossoNumeroComDV 	= 9;    	// Quantidade de dígitos Nosso Número(com DV)
			$this->Fixo     	            = '9';   	// Numero fixo para a posição 05-05
			$this->Ios	  		            = '0';   	// IOS - somente para Seguradoras (Se 7% informar 7, limitado 9%) // Demais clientes usar 0 (zero)
			$this->FatorVencimento         	= $this->base->RetornaFatorVencimento($this->DataVencimento);
			$this->ValorStr                	= $this->base->FormatarValor($this->ValorBoleto);
			$this->NossoNumeroDVStr        	= $this->FormatarNossoNumeroDV();
			$this->NossoNumeroSemDVStr     	= substr($this->NossoNumeroDVStr, 0, strlen($this->NossoNumeroDVStr)-1);
			
			$this->CampoLivre = "";
			
			if ($this->Carteira == 'A') {
				$this->CampoLivre .= '1';
			} else {
				$this->CampoLivre .= '3';
			}
 
			$this->CampoLivre .= "1";
			$this->CampoLivre .= $this->NossoNumeroDVStr;
			$this->CampoLivre .= $this->Convenio;
			$this->CampoLivre .= '1';
			$this->CampoLivre .= '0';

			$dv = $this->Modulo11NN($this->CampoLivre);
			$this->CampoLivre .= $dv ;
		}

		function Modulo11NN($N)
		{			
			$m = 9;
			$Somatorio = 0;
			for ($i = strlen($N)-1; $i >=0; $i--)
			{
				$Somatorio = $Somatorio + ($N[$i] * $m);
				$m--;
				if ($m == 1)
					$m = 9;
			}

			$dv = ($Somatorio % 11);
			if ($dv == 10)
				return '0';
			return $dv;
		}

		function FormatarNossoNumeroDV()
		{			
			$NN = "";
			$NN .= date("y");
			$NN .= '2';
			$NN .= $this->util->ZeroEsquerda($this->SequenciaNossoNumero, 5);
			
			$DV  = "";
			$DV .= $this->util->ZeroEsquerda($this->Convenio, 11) ;
            $DV .= date("y");
            $DV .= '2';
            $DV .= $this->util->ZeroEsquerda($this->SequenciaNossoNumero, 5);  		
			
			$NN .= $this->Modulo11NN($DV);
			
			return $NN ;
		}

		function FormatarNossoNumeroImpresso()
		{			
			$NN = $this->FormatarNossoNumeroDV() ;
			return $this->util->mask('########-#', $NN) ;
		}

		function FormatarCodigoBarras()
		{
			$BarraSemDvTmp = $this->CodigoBanco .$this->NumeroMoeda .$this->FatorVencimento .$this->ValorStr .$this->CampoLivre;
			
			$this->BarraDvStr = $this->base->DigitoCodigoBarras($BarraSemDvTmp);

			$Result  = "";
			$Result .= $this->CodigoBanco;      // 01 - 03 03 Identificação do banco 748
			$Result .= $this->NumeroMoeda;      // 04 - 04 01 Código da moeda 9
			$Result .= $this->BarraDvStr;       // 05 - 05 01 Dígito verificador geral do código de barras
			$Result .= $this->FatorVencimento;  // 06 – 09 04 Fator de vencimento (não obrigatório) 9999
			$Result .= $this->ValorStr;         // 10 - 19 10 Valor 9999999999
			$Result .= $this->CampoLivre;      	// 20 - 44 25 Campo livre Conforme item a seguir
			
			$this->base->CheckCodigoBarras($Result);
			return $Result;
		}

		function FormatarLinhaDigitavel($CodigoBarras)
		{   
			$Campo1 = $this->CodigoBanco .$this->NumeroMoeda .substr($this->CampoLivre,0,5);
			$Campo1 = $Campo1 .$this->base->Modulo10($Campo1);
			$Campo2 = substr($this->CampoLivre, 5, 10)	 .$this->base->Modulo10(substr($this->CampoLivre, 5, 10));
			$Campo3 = substr($this->CampoLivre, 15, 10) .$this->base->Modulo10(substr($this->CampoLivre, 15, 10));
			$Campo4 = $this->BarraDvStr;
			$Campo5 = $this->FatorVencimento .$this->ValorStr;
			
			$Result = $Campo1 .$Campo2 .$Campo3 .$Campo4 .$Campo5;			
			$this->base->CheckLinhaDigitavel($Result);
			return $Result;
		}
    }
	
?>